/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.listeners;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.Optional;
import net.skinsrestorer.api.interfaces.ISRProxyPlayer;
import net.skinsrestorer.api.property.GenericProperty;
import net.skinsrestorer.shared.interfaces.ISRProxyPlugin;
import net.skinsrestorer.shared.listeners.SRPluginMessageEvent;

public abstract class SharedPluginMessageListener {
    private static byte[] convertToByteArray(Map<String, GenericProperty> map) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            out.writeObject(map);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return byteOut.toByteArray();
    }

    public void handlePluginMessage(SRPluginMessageEvent event) {
        ISRProxyPlugin plugin = this.getPlugin();
        if (event.isCancelled()) {
            return;
        }
        if (!event.getTag().equals("sr:messagechannel") && !event.getTag().equals("sr:skinchange")) {
            return;
        }
        if (!event.isServerConnection()) {
            event.setCancelled(true);
            return;
        }
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(event.getData()));
        try {
            String subChannel = in.readUTF();
            String playerName = in.readUTF();
            Optional<ISRProxyPlayer> optional = plugin.getPlayer(playerName);
            if (!optional.isPresent()) {
                return;
            }
            ISRProxyPlayer player = optional.get();
            switch (subChannel) {
                case "getSkins": {
                    int page = in.readInt();
                    if (page > 999) {
                        page = 999;
                    }
                    int skinNumber = 25 * page;
                    Map<String, GenericProperty> skinsList = plugin.getSkinStorage().getSkinsRaw(skinNumber);
                    byte[] ba = SharedPluginMessageListener.convertToByteArray(skinsList);
                    ByteArrayOutputStream b = new ByteArrayOutputStream();
                    DataOutputStream out = new DataOutputStream(b);
                    try {
                        out.writeUTF("returnSkins");
                        out.writeUTF(playerName);
                        out.writeInt(page);
                        out.writeShort(ba.length);
                        out.write(ba);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    if (b.toByteArray().length > 32749) {
                        plugin.getSrLogger().warning("Byte to long in gui... cancel gui..");
                        break;
                    }
                    player.sendDataToServer("sr:messagechannel", b.toByteArray());
                    break;
                }
                case "clearSkin": {
                    plugin.getSkinCommand().onSkinClearOther(player, player);
                    break;
                }
                case "updateSkin": {
                    plugin.getSkinCommand().onSkinUpdateOther(player, player);
                    break;
                }
                case "setSkin": {
                    String skin = in.readUTF();
                    plugin.getSkinCommand().onSkinSetOther(player, player, skin, null);
                    break;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected abstract ISRProxyPlugin getPlugin();
}

